#!/bin/bash
# 6.047 book chapter template
# Author: Abhishek Sarkar <aksarkar@mit.edu
# Usage: bash create_new_chapter.sh NUMBER SHORTNAME LONGNAME
# SHORTNAME is used for naming files and running headers
# LONGNAME is used for the chapter title
set -e
set -u
number=${1?"Missing lecture number"}
shortname=${2?"Missing lecture short name"}
longname=${3?"Misisng lecture long name"}
target="Lecture${number}_$(echo $shortname | sed "s/ \([a-z]\)?/\u\1/")"

mkdir $target
pushd $target
mkdir images
touch $target.bib

cat <<EOF >$target.tex
%% Only edit authors/titles as necessary
\ifdefined\isstandalone
\title{6.047/6.878 Lecture $number: $longname{\tmabbr{}}}
\author{\todo{missing}{add author}}
\maketitle
\chead{6.047/6.878 Lecture $number: $shortname}
\lhead{}
\rhead{}
{\pagebreak}
{\tableofcontents}
{\pagebreak}
{\listoffigures}
\else
\chapter{$longname {\tmabbr{}}}
\author{\todo{missing}{add author}}
\chead{6.047/6.878 Lecture $number: $shortname }
\lhead{} 
\rhead{} 
\minilof
\fi
\pagestyle{fancy} 

\ifdefined\isstandalone
\def\@mydir{images} 
\fi
\ifdefined\ischapter
\def\@mydir{../$target/images} 
\fi 
\ifdefined\ismaster
\def\@mydir{$target/images} 
\fi 

%% Begin editing here
\section{Introduction}
\section{Current Research Directions}
\section{Further Reading}
\section{Tools and Techniques} 
\section{What Have We Learned?}
%% End editing here

\nocite{*}
\bibliographystyle{plain}
\bibliography{$target} 
EOF

cat <<EOF >${target}_standalone.tex
\documentclass{article}
\input{../../templates/preamble}
\input{../../templates/macros} 
\begin{document}
\newcommand{\isstandalone}[1]{\def\@isstandalone{#1}}
\input{$target}
\end{document}
EOF

popd
